IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_RELATORIO_MOVIMENTO_VENDAS_LINHA]'))
DROP VIEW [dbo].[V_RELATORIO_MOVIMENTO_VENDAS_LINHA]
GO
--SELECT * FROM V_RELATORIO_MOVIMENTO_VENDAS_LINHA WHERE DtMovimento between '2017-06-01' and '2017-06-30'
CREATE VIEW V_RELATORIO_MOVIMENTO_VENDAS_LINHA AS
SELECT 
	EST_MOVIMENTO_VENDAS.TIPO_VENDA AS TipoMovimento, 
	V_BI_MOVIMENTO_TIPO.DsTipoMovimento,
	0 as CodigolistaProduto,
	'Venda linha' DsListaProduto,
	'Venda Linha' as Vendedor,
	'Venda Linha' as AtendenteCaixa,	
	V_BI_FILIAL.filial AS Filial,
	V_BI_FILIAL.GrupoEconomico,
	V_BI_FILIAL.Supervisor,
	V_BI_FILIAL.RegiaoFilial,	
	V_BI_FILIAL.Cidade,
	GLB_DT_MOVIMENTO.DT_MOVIMENTO as DtMovimento,
	0 AS Produto,
	'Venda linha' as Descricao,
	V_BI_EST_PROD.Linha,
	V_BI_EST_PROD.Categoria,
	V_BI_EST_PROD.Departamento,
	V_BI_EST_PROD.AreaAtendimento,
	'Venda linha' as NomeFabricante,
    V_BI_EST_PROD.Segmento, 	
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PMC) AS VlrPMC, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA) AS VlrOferta, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD) AS VlrVendaBruta, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS) AS VlrDescItens, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA) AS VlrDescVerba, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_RATEIO) AS VlrDescRateio,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ) AS VlrVdLiquida, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD) AS VlrCustoMedio, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO) AS VlrCustoUltimo, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_GER) AS VlrCustoGer, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_ICMS) AS VlrIcms, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PIS_COFINS) AS VlrPisCofins,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS) AS QtdeItens,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DINHEIRO) AS VlrDinheiro,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES) AS VlrCheques,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_VISTA) AS VlrChequesVista,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_PRAZO) AS VlrChequesPrazo,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CARTAO) AS VlrCartao,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_TICKETS) AS VlrTickets,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DUPLICATA) AS VlrDuplicata,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV) AS VlrConvenio,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV_PBM) AS VlrConvenioPbm,	
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUE_TROCO) AS VlrChequeTroco,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_NCC) AS VlrNcc,
	ISNULL(EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.QTDE_VD,0) AS QtdeVd,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO) AS VlrComissao,
	ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO_FABRIC),0) AS VlrComissaoFabric,
	ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_RECOMPOSICAO_MARGEM),0) AS VlrRecomposicaoMargem,
	V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA AS DsOrigemVenda,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_ISSQN) AS VlrISSQN,
	SUM(ISNULL(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_OUTROS_DESPESAS,0)) 		AS VlrOutrasDespesasItens,
	SUM(ISNULL(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PROD_FRETE,0)) 			AS VlrFreteItens,
	SUM(ISNULL(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_SEGURO,0))					AS VlrSeguroItens 
FROM            
	EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	INNER JOIN V_BI_EST_PROD ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD = V_BI_EST_PROD.produto
	INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN V_BI_MOVIMENTO_TIPO ON
	EST_MOVIMENTO_VENDAS.TIPO_VENDA = V_BI_MOVIMENTO_TIPO.TipoMovimento
	INNER JOIN V_BI_FILIAL ON
	EST_MOVIMENTO_VENDAS.CD_FILIAL = V_BI_FILIAL.filial
	INNER JOIN V_PDV_VD_ORIGEM_VENDA ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_ORIGEM_VENDA = V_PDV_VD_ORIGEM_VENDA.CD_ORIGEM_VENDA
	LEFT OUTER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_CTR_VENDAS AND
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_ORIGEM_VENDA = EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_ORIGEM_VENDA AND
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD = EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_PROD 
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
GROUP BY
	V_BI_FILIAL.Filial,
	EST_MOVIMENTO_VENDAS.TIPO_VENDA, 
	V_BI_MOVIMENTO_TIPO.DsTipoMovimento,
	V_BI_EST_PROD.Linha,
	GLB_DT_MOVIMENTO.DT_MOVIMENTO,
	V_BI_FILIAL.GrupoEconomico,
	V_BI_FILIAL.Supervisor,
	V_BI_FILIAL.RegiaoFilial,	
	V_BI_FILIAL.Cidade,
	V_BI_EST_PROD.Categoria,
	V_BI_EST_PROD.Departamento,
	V_BI_EST_PROD.AreaAtendimento,
	EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.QTDE_VD,
	V_BI_EST_PROD.Segmento,
	V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA  